#include <iostream>
#include <iomanip>
#include <malloc.h>
#include "pawntab.h"
#include "piece.h"
#include "utils.h"
#include "log.h"

using namespace std;

const uint MB = 1000000;

cPawntable::cPawntable()
{
 elements = 4;  //4MB default size
 init_table_memory();
 reset_tables();
}


void cPawntable::delete_tables()
{
   free(table);
   table = NULL;
}

void cPawntable::makenewtable(uint elem)
{
     delete_tables();
     elements = elem;
     init_table_memory();
     reset_tables();
}

void cPawntable::init_table_memory()
{
  //get the size of a hash element
  uint tablesize = sizeof(sPawnelem);
#ifdef DEBUG
  cout<<"\n";
  cout<<"PawnTable elem size = "<<tablesize<<endl;
#endif

  if(elements<1) {cout<<"\n no hash memory defined for pawn table, exiting";exit(1);}

  // mulptiply for MB
  elements   *= MB;

  //divide numelem by the elemsize to get the number of elements
  elements /= tablesize;
#ifdef DEBUG
  cout<<"\n";
  cout<<"Num pawn table elements = "<<elements;
#endif

  table = new sPawnelem[elements];
  if (table == NULL){cout<<"\n error assigning table";exit(1);}

#ifdef DEBUG
  cout<<"\nPawnTable memory size :";
  cout<<" = "<<(_msize(table))/1000<<" kB"<<endl;
#endif

  //reduce element numbers by four to prevent overwriting of the table array
  elements -= 2;

  reset_tables();
}

void cPawntable::reset_tables()
{
   uint i;
   resetcounters();
   for(i = 0; i < elements; ++i)
   {
           table[i].wscore[0] = belowmate;
           table[i].bscore[0] = belowmate;
		   table[i].wscore[1] = belowmate;
           table[i].bscore[1] = belowmate;
           table[i].key=0;
   }
}


void cPawntable::store_pawn(int *wscore, int *bscore, u64 &key)
{
     //make a pointer to assign to point at a table element
     sPawnelem *pElem;
     pElem = table + (key % elements);

	 if(pElem->key==0) write++;

     pElem->key = key;
     pElem->wscore[0] = wscore[0];
	 pElem->wscore[1] = wscore[1];
     pElem->bscore[0] = bscore[0];
	 pElem->bscore[1] = bscore[1];
}


bool cPawntable::probe_pawn(int *wscore, int *bscore, u64 &key)
{
     //make a pointer to assign to point at a table element
     sPawnelem *pElem;
     pElem = table + (key % elements);

     probe++;

     if( pElem->key == key)
     {
      hit++;
      wscore[0] = pElem->wscore[0];
      bscore[0] = pElem->bscore[0];
	  wscore[1] = pElem->wscore[1];
      bscore[1] = pElem->bscore[1];
      return true;
     }
     return false;

}

void cPawntable::says_stats()
{
#ifdef DEBUG
    cout<<"\n Pawn table: ";
    cout<<" write: "<<write<<" probe: "<<probe<<" hit: "<<hit;
    cout<<"\nhit success "<<percent(hit,hit+probe)<<"%";
    cout<<"\n% elements written from total = ";
    cout<<percent(write,elements)<<"%";
#endif
if(logger.islog())
    {
    logger.file<<"\n Pawn table: ";
    logger.file<<" write: "<<write<<" probe: "<<probe<<" hit: "<<hit;
    logger.file<<"\nhit success "<<percent(hit,hit+probe)<<"%";
    logger.file<<"\n% elements written from total = ";
    logger.file<<percent(write,elements)<<"%\n";
    }
}



